import json
import pandas as pd


class Meter:
    def __init__(self, name=None, unit=None, meterId=None, enegiaId=None, df=None, asset_id=None, start=None, end=None):
        self.name = name
        self.unit = unit
        self.meterId = meterId
        self.enegiaId = enegiaId
        self.df = df
        self.asset_id=asset_id
        self.start = start
        self.end = end

    def _serialize(self):
        serialized = {}
        for k,v in  self.__dict__.items():
            if type(v) != pd.DataFrame:
                serialized.update({k: v})
            else:
                serialized.update({k: v.to_dict(orient='list')})
        return serialized

    def _deserialize(self, serialized: dict):
        for k,v in serialized.items():
            if k == 'df':
                setattr(self, k, pd.DataFrame(v))
            else:
                setattr(self, k, v)



class Asset:
    def __init__(self, id=None):
        self.asset_id = id
        self.meters = []
    def add_meter(self, name=None, unit=None, meterId=None, enegiaId=None, df=None, start=None, end=None):
        self.meters.append(Meter(name=name, unit=unit, meterId=meterId, enegiaId=enegiaId, df=df,
                                 asset_id=self.asset_id, start=start, end=end))

    def _serialize(self):
        serialized = {}
        serialized_meters = []
        for k, v in self.__dict__.items():
            if k == 'meters':
                for meter in self.meters:
                    serialized_meters.append(meter._serialize())
            else:
                serialized.update({k: v})
        serialized.update({'meters': serialized_meters})
        return serialized

    def _deserialize(self, serialized):
        for k,v in serialized.items():
            if k == 'meters':
                for meter_serialized in v:
                    meter = Meter()
                    meter._deserialize(meter_serialized)
                    self.meters.append(meter)
            else:
                setattr(self, k, v)

    def save(self, folder):
        with open(f"{folder}/{self.asset_id}.json", 'w') as f:
            json.dump(self._serialize(), f, indent=4)

    def load(self, filepath):
        with open(filepath, 'r') as f:
            self._deserialize(json.load(f))