from numerous.engine.system import Subsystem
from numerous.multiphysics import EquationBase, Equation
from numerous.engine.model import LoggerLevel


class MultiplyByTwo(Subsystem, EquationBase):
    def __init__(self, tag='multiply_by_two'):
        super(MultiplyByTwo, self).__init__(tag)
        self.t1 = self.create_namespace('t1')
        self.add_parameter('input1', 0)
        self.add_parameter('output1', 0, logger_level=LoggerLevel.INFO)
        self.add_state('t', 0)
        self.t1.add_equations([self])

    @Equation()
    def multiply(self, scope):
        scope.output1 = scope.input1 * 2
        scope.t_dot = 1


def entrypoint(tag, system):
    return MultiplyByTwo(tag)