import logging

from numerous.engine.system.subsystem import Subsystem
from numerous.image_tools.system import NumerousSystem

log = logging.getLogger('system_initializer')

class SystemInitializer(Subsystem):
    def __init__(
            self, tag, system: NumerousSystem,
            external_mappings=None, data_loader=None
    ):
        super().__init__(tag, external_mappings=external_mappings, data_loader=data_loader)

        # Basic settings and storage of model items
        self.system = system
        for component in self.system.components.values():
            if component.model:
                self.register_item(component.model)




