import setuptools
import os
from distutils.util import convert_path

cwd = os.getcwd().replace('\\', '/').replace(" ", "%20")
local_packages = f"{cwd}/local_packages_to_be_removed"

ver_path = convert_path('version.txt')
ver=None
if os.path.exists(ver_path):
    with open(ver_path) as ver_file:
        ver=ver_file.read()

setuptools.setup(
    name="numerous-engine-tools",
    version=ver,
    author='Tobias Dokkedal Elmøe, EnergyMachines ApS',
    author_email='tobias.dokkedal.elmoe@energymachines.com',
    description="Numerous engine tools for numerous platform",
    long_description="",
    long_description_content_type="text/markdown",
    url="",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: BSD License",
        "Operating System :: OS Independent",
    ],
    install_requires=[
        f"numerous_image_tools==2.13.7",
        "numpy==1.22.0",
        'numerous-engine==0.3.1',
    ],
    packages=setuptools.find_namespace_packages(where='src'),
    package_dir={'': 'src'},
    include_package_data=True,
    python_requires='>=3.10',
)
