import setuptools
import os
from distutils.util import convert_path
from pathlib import Path

root = Path(os.getcwd().replace('\\', '/').replace(" ", "%20"))

local_package_dir = root / Path("local_packages_to_be_removed")

ver_path = convert_path('version.txt')
ver=None
if os.path.exists(ver_path):
    with open(ver_path) as ver_file:
        ver=ver_file.read()

branch=os.getenv("CI_COMMIT_BRANCH", None)
if branch and branch == "alpha":
    ver+="a"

setuptools.setup(
    name="numerous-image-tools",
    version=ver,
    author='Tobias Dokkedal Elmoee, EnergyMachines ApS',
    author_email='tobias.dokkedal.elmoe@energymachines.com',
    description="Numerous platform image tools",
    long_description="",
    long_description_content_type="text/markdown",
    url="",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: BSD License",
        "Operating System :: OS Independent",
    ],
    install_requires=[
        f"numerous_api_client @ file://localhost/{local_package_dir.as_posix()}/api_client/",
        'api_grpc @ https://pypi.numerously.com/packages/api_grpc-0.2.tar.gz#md5=f866de36eaa8bbd1316d1d7cb913089b',
        'client_common @ https://pypi.numerously.com/packages/client_common-0.1.tar.gz#md5=601a39af74ab7447373995ecd73d24f4',
        'dirtools_numerous @ https://pypi.numerously.com/packages/dirtools_numerous-0.2.1.tar.gz#md5=e62af7ef614c2be38eb293d129f26d73',
        f"numerous_cli @ file://localhost/{local_package_dir.as_posix()}/command_line/",
    ],
    packages=setuptools.find_packages(),
    python_requires='>=3.9',
)
