import json
from pathlib import Path
from typing import Callable

import pytest

from numerous.cli import NumerousRepository


def test_load_invalid_repositories(get_repository_path: Callable[[str], Path]):
    repo_path = get_repository_path(json.dumps({}))
    repo = NumerousRepository(repo_path)
    assert repo.path == repo_path
    with pytest.raises(KeyError):
        repo.load()
