#!/bin/bash

if [ "$1" = "tests" ]; then
  # TESTS
  echo "Running unit-tests..."

  python -m pytest \
    --color=yes \
    --code-highlight=yes \
    --cov-report=xml:/coverage.xml \
    --cov-report=term-missing \
    --cov=./src \
    --junitxml=/tests.xml \
    ./tests

elif [ "$1" = "linters" ]; then
  # LINTERS
  echo "Running linters..."

  echo "> running isort..."
  python -m isort --check-only --skip-glob=misc .; exit_code=$?

  echo "> running flake..."
  python -m flake8 --extend-exclude=./misc,vulture_whitelist.py --show-source . || exit_code=$?

  echo "> running vulture..."
  python -m vulture --exclude misc --min-confidence=70 . vulture_whitelist.py || exit_code=$?

  echo "> running bandit..."
  python -m bandit --exclude=./tests,./misc -r . || exit_code=$?

  echo "> running mypy..."
  rm -rf .mypy_cache
  python -m mypy --no-incremental tests src || exit_code=$?
  rm -rf .mypy_cache

  exit ${exit_code}

else
  echo "Unknown command: '$1'"
  exit 1

fi
