
from numerous_api_client.client import open_admin_client

import logging
import datetime

logging.basicConfig(level=logging.DEBUG)
log = logging.getLogger('numerous-test-log.main')
log.setLevel(logging.DEBUG)
from time import sleep, time

from dotenv import load_dotenv

if __name__ == '__main__':
    load_dotenv()

    with open_admin_client() as client:
        try:

            stats = client.get_timeseries_stats(scenario= '27UFgqui46hCcI2xP1pQ', execution="1e2ac953-fd31-4d8e-8b72-e508b2e7af17")

            print(stats)

            tic = time()
            count = 0
            for b in client.read_data_stream(scenario='27UFgqui46hCcI2xP1pQ',
                                        execution="1e2ac953-fd31-4d8e-8b72-e508b2e7af17", tags=[
                        'system.ClimateMachine-0.outlet_manifold_outside_element_2.t1.T',
                        'system.ClimateMachine-0.HX_Controller_app.t1.machine_state',
                        'system.ClimateMachine-0.inlet_source_outside_element_1.t1.T',
                        'system.ClimateMachine-0.inlet_source_outside_element_1.t1.q_flow',
                        'system.ClimateMachine-0.inlet_source_extract_element_2.t1.T',

                    ]):
                count+=1

            toc = time()
            print('Read time: ', toc-tic, ' n blocks: ', count)

        finally:
            log.debug('Complete')