import logging

from numerous_image_tools.job import NumerousBaseJob
from numerous_image_tools.app import run_job

logger = logging.getLogger('multiply-by-two')

class MultiplyByTwo(NumerousBaseJob):

    def initialize_simulation_system(self):
        self.numerous_name = 'example'

    def step(self, t: float = None, dt: float = None):
        component = self.system.components[self.numerous_name]  # Get the component named 'example' from the frontend
        inputs = component.inputs  # This dict contains the inputs to the named component
        model = component.model  # This allows the user to access the user instantiated python model class
        outputs = model.multiply_by_two(inputs, t)  # a dict with outputs

        return t + dt, outputs


def run_example():
    run_job(numerous_job=MultiplyByTwo(), appname="multiply-by-two", model_folder="numerous_image_tools.example_models")


if __name__ == "__main__":
    logging.basicConfig(level=logging.DEBUG)
    run_example()
