import pytest
from pytest_mock import MockerFixture

import spm_pb2


@pytest.fixture
def mock_grpc(mocker: MockerFixture):
    mocker.patch("grpc.secure_channel", return_value=None)
    mocker.patch("grpc._interceptor._Channel")
    mock_spm = mocker.patch("spm_pb2_grpc.SPMStub")
    mock_spm.SubscribeForUpdates.return_value = (("channel", "{}") for _ in range(1))
    mock_token_manager = mocker.patch("spm_pb2_grpc.TokenManagerStub")
    mock_token_manager().GetAccessToken.return_value = spm_pb2.Token(val="token")
    return mock_spm, mock_token_manager


@pytest.fixture
def mock_spm(mock_grpc):
    return mock_grpc[0]


@pytest.fixture
def mock_token_manager(mock_grpc):
    return mock_grpc[1]
