from dotenv import load_dotenv
load_dotenv()
from numerous_api_client.client import NumerousClient
import logging
from time import sleep

log = logging.getLogger('main.simulation')
log.setLevel(logging.DEBUG)

from threading import Thread, Event


def noop_tester(stop_event:Event, name="tester0", period=1):
    client = NumerousClient()
    while not stop_event.is_set():
        client.noop()
        print(f"{name}: noop, sleep: {period}")

        sleep(period)
    client.close()

import signal


def run(n_clients):
    clients = []
    done = False
    stop_event = Event()

    def stop():
        print('Stopping all threads!')
        stop_event.set()

    signal.signal(signal.SIGINT, stop)
    signal.signal(signal.SIGTERM, stop)


    try:
        for i in range(n_clients):
            noop_thread = Thread(target=noop_tester, args=(stop_event,), kwargs={'name': 't'+str(i), 'period': 1})
            clients.append(noop_thread)
            noop_thread.start()

        input('Press enter to stop!')
        stop()
        [client_thread.join() for client_thread in clients]
        print('All threads joined')
        done = True
    finally:
        if not done:
            print('Calling stop!')
            stop()

            [client_thread.join() for client_thread in clients]
            raise


if __name__ == '__main__':
    run(1)