from dotenv import load_dotenv
from numerous_api_client.client import open_client
import time
import logging
import json

load_dotenv()

def hibernation_callback(client: open_client, state: dict) -> None:
    logging.info(f"Hibernating and setting state: {state}")
    client.set_state(state=state)


def _to_json_acceptable(data: str) -> str:
    return data.replace("'", '"')


def handle_initial_state(client: open_client) -> dict:
    state = client.get_state()
    if state is None or not client.was_resumed():
        logging.debug(f"State was None (state: {state}) or client was not resumed. (client resumed: {client.was_resumed()}).")
        return {'i': 0}

    state = state if not isinstance(state, str) else json.loads(_to_json_acceptable(data=state))
    return state


def run():
    with open_client() as client:
        state = handle_initial_state(client=client)
        client.set_hibernation_callback(func=hibernation_callback, client=client, state=state)

        initial_i = state['i'] if state is not None and isinstance(state, dict) and 'i' in state.keys() else 0

        for i in range(initial_i, 100):
            state['i'] = i + 1

            logging.info(f"Updating progress: {i}")
            client.set_scenario_progress('Running', 'running', i + 1)

            if (i + 1) % 25 == 0 and (i + 1) != 100:
                client.set_scenario_progress('Hibernating', 'hibernating', i + 1, force=True)
                client.hibernate()

            elif (i + 1) == 100:
                client.set_state({'i': 100})

            time.sleep(.5)


if __name__ == '__main__':
    run()
