from pathlib import Path
from typing import Optional

from numerous_api_client.client import NumerousAdminClient, NumerousClient

from .repository import NumerousRepository


def get_client(path: Optional[Path] = None, clear_data: Optional[bool] = None, no_log: bool = False,
               instance_id: Optional[str] = None, reset_job: Optional[bool] = True) -> NumerousClient:
    path = path or Path.cwd()
    repo = NumerousRepository(path).load()
    # Reset the job to clear the current instance/execution for local running
    if reset_job:
        admin_client = get_admin_client(path)
        admin_client.reset_job(repo.scenario.project_id, repo.scenario.id, repo.remote.job_id)
        admin_client.close()
    return NumerousClient(
        url=repo.remote.api_url,
        project=repo.scenario.project_id,
        scenario=repo.scenario.id,
        job_id=repo.remote.job_id,
        refresh_token=repo.token,
        clear_data=clear_data,
        no_log=no_log,
        instance_id=instance_id)


def get_admin_client(path: Optional[Path] = None) -> NumerousAdminClient:
    path = path or Path.cwd()
    repo = NumerousRepository(path).load()
    return NumerousAdminClient(url=repo.remote.api_url, refresh_token=repo.token)
