class NumerousBaseJob:
    def __init__(self):
        self.system = None
        self.align_outputs_to_next_timestep = True

    def initialize_simulation_system(self):
        """
        A method that is called once the first data is read. All initialization should be done here.
        Can return the initial output to be saved.
        """
        return

    def step(self, t: float = None, dt: float = None):
        """
        A method that is called after each data read. Could be a step solver, or some other data manipulating function.
        Returns: tuple of next timestamp and outputs as a dict with tags to be saved

        """
        return t+dt, {"no_job_defined": None}

    def serialize_states(self, t: float = None):
        """
        A method called when saving states.
        Returns: states as a json serializable object, to be saved.
        """
        return {}
