from numerous_api_client.client import open_client
from time import sleep, time
from dotenv import load_dotenv
import logging
import datetime

logging.basicConfig(level=logging.DEBUG)
log = logging.getLogger('numerous-test-log.main')
log.setLevel(logging.DEBUG)


if __name__ == '__main__':
    load_dotenv()

    with open_client() as client:
        log.debug('resumed: '+str(client._was_resumed))
        if client.was_resumed():
            state = client.get_state()

            log.debug('Job resuming with state: ' + str(state) + " " +str(type(state)))

        else:
            log.debug('Job has not been resumed before!. Initializing.')
            state = {'resumed_no_times': 0}


        def hibernate_():
            state['resumed_no_times'] += 1

            client.set_state(state, force=True)

            log.debug('Hibernation callback. Hibernation number is: '+str(state['resumed_no_times']))

        log.debug('Setting hibernation callback')

        client.set_hibernation_callback(hibernate_)

        sleep(5)

        log.debug('hibernating...')
        log.debug('state: '+str(state) +" "+str(type(state)))
        if state['resumed_no_times'] < 10:
            client.hibernate()
