from numerous_image_tools.job import NumerousBaseJob
from numerous_image_tools.app import run_job
from numerous_image_tools.system import NumerousSystem
import logging

logger = logging.getLogger('multiply-by-two')

class SimpleModel(NumerousBaseJob):

    def initialize_simulation_system(self, system: NumerousSystem = None):

        self.system = system
        tags = []
        for component in system.components:
            item = system.model_items[component.name]
            tags += item.get_output_tags(system.initial_data[0])

        return tags

    def serialize_states(self, t: float = None):
        pass

    def deserialize_states(self, states: object = None):
        return states

    def step(self, data: dict = None, t: float = None, dt: float = None):
        outputs = []

        for d in data:
            for component in self.system.components:
                item = self.system.model_items[component.name]
                output=item.multiply_by_two(d, t)
                outputs.append(output)

        return t+dt, outputs

def run_example():
    run_job(numerous_job=SimpleModel(), appname="multiply-by-two", model_folder="numerous_image_tools.example_models")

if __name__ == "__main__":
    run_example()