from abc import ABC, abstractmethod
from .system import NumerousSystem

class NumerousBaseJob(ABC):

    @abstractmethod
    def initialize_simulation_system(self, system: NumerousSystem = None):
        """
        A method that is called once the first data is read. All initialization should be done here.
        Returns: Outputs from the system formatted as a list of dictionaries containing key 'name' and value of
        equal to output tag name i.e. [{'name': "test_output'}]
        """

    @abstractmethod
    def step(self, data: dict = None, t: float = None, dt: float = None):
        """
        A method that is called after each data read. Could be a step solver, or some other data manipulating function.
        Returns: tuple of next timestamp and outputs as a list of dicts with tags to be saved from the function

        """

    @abstractmethod
    def serialize_states(self, t: float = None):
        """
        A method called when saving states.
        Returns: states as a json serialized object, to be saved.
        """
        return {}

    @abstractmethod
    def deserialize_states(self, states: object = None):
        """
        A method called when loading states.
        Returns the deserialized states object
        """
        return states
