import json
from numerous_image_tools.image_test.build import build_image
from numerous_image_tools.image_test.run import run_container

def read_numerous_environment(config_folder):

    with open(config_folder+'/.numerous.repository.json', 'r') as f:
        repo_config = json.load(f)


    project = repo_config['scenario'].split(':')[0]
    scenario = repo_config['scenario'].split(':')[1]
    job_id =  repo_config['remote'].split('/')[-2]
    server =  repo_config['remote'].split('/')[2]
    https = repo_config['remote'].split('/')[0]

    config = {
        'NUMEROUS_SCENARIO': scenario,
        'NUMEROUS_PROJECT': project,
        'JOB_ID': job_id,
        'NUMEROUS_API_REFRESH_TOKEN': repo_config['token'],
        'NUMEROUS_API_PORT': '443',
        'NUMEROUS_API_SERVER': server,
        'SECURE_CHANNEL': "True" if https else "False"
    }

    return config

def build_run_numerous_image(docker_context_folder=".", numerous_config_folder="."):
    environment = read_numerous_environment(numerous_config_folder)
    image_id = build_image(docker_context_folder)

    run_container(image_id, environment)


