from report_generator.report import Report
from pathlib import Path

def get_client(auto_generated, instance_id, path_str='..'):

    if auto_generated:
        from numerous_api_client.client import NumerousClient
        client = NumerousClient(instance_id=instance_id)
    else:
        from numerous.cli.client import get_client
        client = get_client(Path(path_str), reset_job=True)
    
    return client

def get_report(client, template, report_filename):

    report = Report(client.upload_file)
    report.template = template
    report.filename = './output/'+report_filename


    return report
    
def get_report_with_client(auto_generated, template, report_filename, instance_id):
    client = get_client(auto_generated, instance_id)
    report = get_report(client, template, report_filename)
    return client, report
    

def get_component_by_name(scenario, name):
    for c in scenario['simComponents']:
        if c['name']==name:
            return c

def get_simcomponent_parameter_value(name, param):
    c = get_component_by_name(name)
    for p in c['parameters']:
        #print(p['displayName'])
        if p['displayName'] == param:

            return p['value']
    raise KeyError('Param not found!')
        
def get_comp(comp):
    try:
        return not get_component_by_name(comp)['disabled']
    except:
        return False