from setuptools import setup, find_packages
import os
from distutils.util import convert_path

ver_path = convert_path('version.txt')
ver=None
if os.path.exists(ver_path):
    with open(ver_path) as ver_file:
        ver=ver_file.read()

setup(name='numerous-image-tools',
      version=ver,
      description='Tools for working with numerous images.',
      url='https://gitlab.com/numerous-resources/numerous-image-test',
      author='Lasse Thomsen',
      author_email='Lasse.Thomsen@EnergyMachines.com',
      license='OBSD-3',
      dependency_links = ['http://pypi.numerously.com/simple/'],
      install_requires=['ipywidgets',
                        'ipython',
                        'plotly',
                        'pandas',
                        'numpy',
                        'jinja2',
                        'json2html',
                        'numerous-api-client',
                        'numerous-cli',
                        'numerous-report-generator',
                        'docker'],
      packages=find_packages())
