from numerous_api_client.client.numerous_client import NumerousClient, ScenarioStatus


class NumerousJob:

    def __init__(self, client: NumerousClient):
        self._client = client

        self._client.set_hibernation_callback(self._hibernation_callback)

        self.state = self._client.state
        self.hibernate_event = self._client.hibernate_event
        self.terminate_event = self._client.terminate_event


        self._timeout = 20
        self._terminate = False

    def _hibernation_callback(self):
        self.state.commit()
        print('State comitted and job hibernated!')

    def _event_watch(self):
        while not self._terminate:
            if self.hibernate_event.is_set():
                self.payload_thread.join(self._timeout)
                if self.payload_thread.is_alive():
                    self.payload_thread.kill()
                break

            if self.terminate_event.is_set():
                self.payload_thread.join(self._timeout)
                if self.payload_thread.is_alive():
                    self.payload_thread.kill()
                break

            time.sleep(0.01)


    def progress(self, message: str, status: ScenarioStatus, progress: float):
        self._client.set_scenario_progress(message, status, progress)

    def run_job(self):
        #Start the thread watching events from numerous
        self.event_watch_thread = threading.Thread(target=self._event_watch)
        self.event_watch_thread.start()

        self.progress("Starting job", ScenarioStatus.INITIALZING, 0.0)

        #Start the payload thread
        self.payload_thread = ThreadWithTrace(name="payload", target=self.run, args=(self._client, ), daemon=True)
        self.payload_thread.start()
        self.payload_thread.join()

        self._terminate=True
        self.event_watch_thread.join()

    #Overwrite this method with your own code
    def run(self, client: NumerousClient):
        while True:
            time.sleep(1)

            if self.terminate_event.is_set():
                break


def entrypoint(client: NumerousClient):

    job = NumerousJob(client)
    job.run_job()


# Python program using
# traces to kill threads

import sys
import threading
import time


class ThreadWithTrace(threading.Thread):
    def __init__(self, *args, **keywords):
        threading.Thread.__init__(self, *args, **keywords)
        self.killed = False

    def start(self):
        self.__run_backup = self.run
        self.run = self.__run
        threading.Thread.start(self)

    def __run(self):
        sys.settrace(self.globaltrace)
        self.__run_backup()
        self.run = self.__run_backup

    def globaltrace(self, frame, event, arg):
        if event == 'call':
            return self.localtrace
        else:
            return None

    def localtrace(self, frame, event, arg):
        if self.killed:
            if event == 'line':
                raise SystemExit()


        return self.localtrace

    def kill(self):
        self.killed = True






