import traceback
import importlib
import logging
import os

from numerous_api_client.client import open_client

logging.basicConfig(level=logging.DEBUG)
log = logging.getLogger('numerous.main')
log.setLevel(logging.DEBUG)

def run(object_path, workdir='.'):

    os.chdir(workdir)

    #Open the numerous client
    with open_client() as client:
        try:

            get_entrypoint(object_path)(client)

        except (KeyboardInterrupt):
            client.set_scenario_progress('Job terminated', 'terminated', force=True)

        except Exception:
            tb = traceback.format_exc()
            log.error(tb)
            client.set_scenario_progress('Job failed!', 'failed', force=True)
            return tb
        return ""

def get_entrypoint(object_path):
    object_path_list = object_path.split('.')
    module_ = object_path_list[:-1]
    object_ = object_path_list[-1]

    file_ = module_[-1]

    location_ = "/".join(module_) + '.py'

    spec_ = importlib.util.spec_from_file_location(file_, location_)

    globals()[file_] = importlib.util.module_from_spec(spec_)
    spec_.loader.exec_module(globals()[file_])
    return getattr(globals()[file_], object_)