import setuptools
import os
from distutils.util import convert_path
from pathlib import Path

ver_path = convert_path('version.txt')
ver=None
if os.path.exists(ver_path):
    with open(ver_path) as ver_file:
        ver=ver_file.read()

root = Path(os.getcwd().replace('\\', '/').replace(" ", "%20"))

local_package_dir = root / Path("src")

setuptools.setup(
    name="numerous-image-tools",
    version=ver,
    author='Tobias Dokkedal Elmoee, EnergyMachines ApS',
    author_email='tobias.dokkedal.elmoe@energymachines.com',
    description="Numerous platform image tools",
    long_description="",
    long_description_content_type="text/markdown",
    url="",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: BSD License",
        "Operating System :: OS Independent",
    ],
    install_requires=[
        "grpc-interceptor>=0.13.0", "grpcio>=1.42.0", "numpy>=1.21.4", "protobuf>=3.19.1",
                        "pytz==2021.3", "requests>=2.26.0", "scipy>=1.7.3", "str2bool>=1.1",
                        "colorama>=0.4.4", "prettytable>=2.4.0", "ipywidgets>=7.7.0", "plotly>=5.6.0",
                        "networkx>=2.8", "numerous-cli==0.8.1", "numerous-api-client==0.14.1a1",
                        "Jinja2==3.0.3"
    ],
    packages=setuptools.find_namespace_packages(where='src'),
    package_dir={'': 'src'},
    include_package_data=True,
    python_requires='>=3.9',
    
)
