#!/bin/bash

if [ "$1" = "tests" ]; then
  # TESTS
  echo "Running processing unit-tests..."

  python -m pytest \
    --color=yes \
    --code-highlight=yes \
    --cov-report=xml:/coverage.xml \
    --cov-report=term-missing \
    --cov=./src \
    --junitxml=/tests.xml \
    ./tests

elif [ "$1" = "linters" ]; then
  # LINTERS
  echo "Running linters..."

  echo "> running isort..."
  python -m isort --check-only .; exit_code=$?

  echo "> running flake..."
  python -m flake8 --show-source . || exit_code=$?

  echo "> running vulture..."
  python -m vulture --min-confidence=70 . || exit_code=$?

  echo "> running bandit..."
  python -m bandit --exclude=./tests -r . || exit_code=$?

  echo "> running mypy..."
  rm -rf .mypy_cache
  python -m mypy --no-incremental . || exit_code=$?
  rm -rf .mypy_cache

  exit ${exit_code}

else
  echo "Unknown command: '$1'"
  exit 1

fi
