from pathlib import Path
from typing import List
from uuid import uuid1

import pytest

from numerous.cli import NumerousRepository


@pytest.fixture
def get_repository_path():
    dirs: List[Path] = []
    files: List[Path] = []

    def fn(repository_config_content: str):
        repo_path = Path(str(uuid1()))
        repo_path.mkdir()
        config_path = repo_path / str(NumerousRepository.FILE_NAME)
        dirs.append(repo_path)
        files.append(config_path)
        with config_path.open("w") as fp:
            fp.write(repository_config_content)
        return repo_path

    yield fn

    for file in files:
        file.unlink(missing_ok=True)
    for dir in dirs:
        dir.rmdir()
