import setuptools
import os
from distutils.util import convert_path
from pathlib import Path

def package_files(basedir):
    paths = []
    for (path, directories, filenames) in os.walk(basedir):
        for filename in filenames:
            paths.append("/".join([Path(path).relative_to(Path(basedir)).as_posix(),filename]))
    return paths

root = Path(os.getcwd().replace('\\', '/').replace(" ", "%20"))

local_package_dir = root / Path("local_packages_to_be_removed")

ver_path = convert_path('version.txt')
ver=None
if os.path.exists(ver_path):
    with open(ver_path) as ver_file:
        ver=ver_file.read()

packages = setuptools.find_packages()
packages.append('numerous_cli')

setuptools.setup(
    name="numerous-image-tools",
    version=ver,
    author='Tobias Dokkedal Elmoee, EnergyMachines ApS',
    author_email='tobias.dokkedal.elmoe@energymachines.com',
    description="Numerous platform image tools",
    long_description="",
    long_description_content_type="text/markdown",
    url="",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: BSD License",
        "Operating System :: OS Independent",
    ],
    packages=packages,
    package_dir={'numerous_cli': 'local_packages_to_be_removed/command_line/src/numerous_cli'},
    package_data = {'numerous_cli': package_files('local_packages_to_be_removed/command_line/src')},
    #                'numerous_api_client': package_files('local_packages_to_be_removed/api_client/src')},
    include_package_data=True,
    #package_data = {'local_packages_to_be_removed': ['./testis/*']},
    install_requires=[
        'dirtools_numerous==0.2.1',
        "grpc-interceptor>=0.13.0", "grpcio>=1.42.0", "numpy>=1.21.4", "protobuf>=3.19.1",
                        "pytz==2021.3", "requests>=2.26.0", "scipy>=1.7.3", "str2bool>=1.1",
                        "colorama>=0.4.4", "prettytable>=2.4.0", "ipywidgets>=7.7.0", "plotly>=5.6.0",
                        "networkx>=2.8",
        f"numerous_cli @ file://localhost/{local_package_dir.as_posix()}/command_line/",
        f"numerous_api_client @ file://localhost/{local_package_dir.as_posix()}/api_client/"
    ],
    python_requires='>=3.9',
)
