from time import sleep, time

from numerous.client.common import RepeatedFunction


def test_repeated_function_run_initially():
    state = {"count": 0}

    def increase_count():
        state["count"] += 1
    assert state["count"] == 0, "The repeated function should not run yet"
    RepeatedFunction(0.1, increase_count, run_initially=True)
    assert state["count"] == 1, "The repeated function should run initially"


def test_repeated_function_10_repititions():
    state = {"count": 0, "time": None}

    def increase_count():
        if state["count"] < 10:
            state["count"] += 1
            state["time"] = time()

    before = time()
    repeated_function = RepeatedFunction(0.01, increase_count)
    repeated_function.start()

    sleep(0.2)
    repeated_function.stop()

    assert state["count"] == 10
    assert state["time"] - before >= 0.1, "It should take at least 10 times 1 repetition time"
