import pytest
import time

from threading import Event
from time import sleep
from pytest_mock import MockerFixture

from numerous.client.data_source import DynamicSource, InputManager, DataSourceStreamStarting
from numerous.client import NumerousClient, DataSourcesReader

T_START = 5
TIMEOUT = 30
MOCKDATA = {'mockdata': 1}

@pytest.fixture
def client(mocker: MockerFixture):
    def read_data_as_row_mock(*args, **kwargs):
        start=time.time()
        def open_data_source_mock():
            _index = -1
            while True:
                if time.time()-start > T_START:
                    _index += 1
                    return_result = MOCKDATA.copy()
                    return_result.update({'_index': _index})
                    yield return_result
        data = open_data_source_mock()
        for d in data:
            yield d

    class Meta:
        def __init__(self):
            self.tags = []
            self.offset = 0

    class Stats:
        def __init__(self):
            self.min = 0

    client = mocker.MagicMock(NumerousClient)
    client.hibernate_event = Event()
    client.terminate_event = Event()
    client.read_data_as_row = mocker.MagicMock(side_effect=read_data_as_row_mock)
    client.get_timeseries_meta_data.return_value = Meta()
    client.get_dataset_closed.return_value = True
    client.get_timeseries_stats.return_value = Stats()
    client.state.get.return_value = True

    return client


def test_data_source_stream_starting(client):
    spec = {'tags': {'mockdata': {'tag': 'mockdata', 'scale': 1, 'offset': 0}}, 'offset': 0}
    source = DynamicSource(client, "", "", spec)
    start = time.time()

    while True:
        data = None
        try:
            data = source.get_at_time(0)
        except Exception as e:
            assert e.__class__ == DataSourceStreamStarting, f'expected {DataSourceStreamStarting} but got {e.__class__}'
        if data:
            assert data == MOCKDATA, f"expected {MOCKDATA} but got {data}"
            break
        assert time.time()-start < TIMEOUT, f"test did not complete within {TIMEOUT}"

        sleep(0.1)

def test_data_sources_reader_read(mocker: MockerFixture, client):
    def get_inputs_mock(*args, **kwargs):
        spec = {'tags': {}, 'offset': 0}
        source = DynamicSource(client, "", "", spec)
        return InputManager([source], 0, 0)

    client.get_inputs = mocker.MagicMock(side_effect=get_inputs_mock)
    reader = DataSourcesReader(client, {}, 0, 0, 0, 0, '', '', 1)
    reader._wait_for_stream_start = 0
    data = reader.read(0)
    assert data is None, f"Expected None but got {data}"
