from cryptography import x509
from cryptography.hazmat.backends import default_backend


def get_cert_cn(cert: bytes) -> str:
    cert_decoded = x509.load_pem_x509_certificate(cert, default_backend())
    return cert_decoded.subject.rfc4514_string().split('CN=')[-1].split(',')[0]
