from unittest.mock import MagicMock

import spm_pb2

from numerous.client import NumerousAdminClient


def test_read_execution_logs(mock_spm: MagicMock):
    from datetime import datetime
    client = NumerousAdminClient(server="https://server", port=50000, secure=True, refresh_token="refresh")
    try:
        mock_spm().ReadExecutionLogEntries.return_value = [
            spm_pb2.ExeLogEntry(execution_id='execution_id', log_entry='Entry 1', timestamp=1649900000),
            spm_pb2.ExeLogEntry(execution_id='execution_id', log_entry='Entry 2', timestamp=1649900001)
        ]
        logs = list(client.read_execution_logs(execution_id="execution_id", project_id="project_id"))
    finally:
        client.close()

    expected_request = spm_pb2.ExecutionReadLogs(execution_id="execution_id", project_id="project_id", start=0, end=0)
    mock_spm().ReadExecutionLogEntries.assert_called_once_with(expected_request)
    assert logs == [('Entry 1', datetime.fromtimestamp(1649900000)), ('Entry 2', datetime.fromtimestamp(1649900001))]


def test_launch_job(mock_job_manager: MagicMock):
    client = NumerousAdminClient(server="https://server", port=50000, secure=True, refresh_token="refresh")
    try:
        mock_job_manager().StartJob.return_value = spm_pb2.ExecutionId(execution_id="execution_id")
        execution_id = client.launch_job("project_id", "scenario_id", "job_id")
    finally:
        client.close()

    expected_request = spm_pb2.Job(project_id="project_id", scenario_id="scenario_id", job_id="job_id",
                                   organization_id="EnergyMachines", user_id="test_user")
    mock_job_manager().StartJob.assert_called_once_with(expected_request)
    assert execution_id == "execution_id"


def test_terminate_job(mock_job_manager: MagicMock):
    client = NumerousAdminClient(server="https://server", port=50000, secure=True, refresh_token="refresh")
    try:
        client.terminate_job("project_id", "scenario_id", "job_id")
    finally:
        client.close()

    expected_request = spm_pb2.Job(project_id="project_id", scenario_id="scenario_id", job_id="job_id",
                                   organization_id="EnergyMachines", user_id="test_user")
    mock_job_manager().TerminateJob.assert_called_once_with(expected_request)


def test_reset_job(mock_job_manager: MagicMock):
    client = NumerousAdminClient(server="https://server", port=50000, secure=True, refresh_token="refresh")
    try:
        client.reset_job("project_id", "scenario_id", "job_id")
    finally:
        client.close()

    expected_request = spm_pb2.Job(project_id="project_id", scenario_id="scenario_id", job_id="job_id",
                                   organization_id="EnergyMachines", user_id="test_user")
    mock_job_manager().ResetJob.assert_called_once_with(expected_request)


def test_hibernate_job(mock_job_manager: MagicMock):
    client = NumerousAdminClient(server="https://server", port=50000, secure=True, refresh_token="refresh")
    try:
        client.hibernate_job("project_id", "scenario_id", "job_id", "organization_id", "user_id")
    finally:
        client.close()

    expected_request = spm_pb2.Job(project_id="project_id", scenario_id="scenario_id", job_id="job_id",
                                   organization_id="organization_id", user_id="user_id")
    mock_job_manager().HibernateJob.assert_called_once_with(expected_request)


def test_resume_job(mock_job_manager: MagicMock):
    client = NumerousAdminClient(server="https://server", port=50000, secure=True, refresh_token="refresh")
    try:
        client.resume_job("project_id", "scenario_id", "job_id", "organization_id", "user_id")
    finally:
        client.close()

    expected_request = spm_pb2.Job(project_id="project_id", scenario_id="scenario_id", job_id="job_id",
                                   organization_id="organization_id", user_id="user_id")
    mock_job_manager().ResumeJob.assert_called_once_with(expected_request)
