import logging
import os
from numerous.image_tools.job import NumerousSimulationJob
from numerous.image_tools.app import run_job

logger = logging.getLogger('multiply-by-two')

class MultiplyByTwo(NumerousSimulationJob):

    def initialize_simulation_system(self):
        self.numerous_name = 'example'
        self.align_outputs_to_next_timestep = False

    def step(self, t: float = None, dt: float = None):
        component = self.system.components[self.numerous_name]  # Get the component named 'example' from the frontend
        inputs = component.inputs  # This dict contains the inputs to the named component
        model = component.model  # This allows the user to access the user instantiated python model class
        outputs = model.multiply_by_two(inputs, t)  # a dict with outputs
        outputs.update({'resumed': len(self.system.states) > 0})  # output resumed True if job is resumed
        return t + dt, outputs

    def serialize_states(self, t: float = None):
        return True


def run_example():
    run_job(numerous_job=MultiplyByTwo(), appname="multiply-by-two", model_folder="numerous.image_tools.example_models")


if __name__ == "__main__":
    logging.basicConfig(level=logging.DEBUG)
    run_example()
