import setuptools
import os
from distutils.util import convert_path

ver_path = convert_path('version.txt')
ver=None
if os.path.exists(ver_path):
    with open(ver_path) as ver_file:
        ver=ver_file.read()

setuptools.setup(
    name="numerous-image-tools",
    version=ver,
    author='Tobias Dokkedal Elmoee, EnergyMachines ApS',
    author_email='tobias.dokkedal.elmoe@energymachines.com',
    description="Numerous platform image tools",
    long_description="",
    long_description_content_type="text/markdown",
    url="",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: BSD License",
        "Operating System :: OS Independent",
    ],
    install_requires=[
        'dirtools_numerous==0.2.1',
        "grpc-interceptor>=0.13.0", "grpcio>=1.42.0", "numpy>=1.21.4", "protobuf>=3.19.1",
                        "pytz==2021.3", "requests>=2.26.0", "scipy>=1.7.3", "str2bool>=1.1",
                        "colorama>=0.4.4", "prettytable>=2.4.0", "ipywidgets>=7.7.0", "plotly>=5.6.0",
                        "networkx>=2.8", "numerous-cli>=0.8.0", "numerous-api-client>=0.12.3b1"
    ],
    package_dir={'': 'src'},
    include_package_data=True,
    packages=setuptools.find_namespace_packages(where='src'),
    python_requires='>=3.9',
    
)
