from numerous_api_client.client import open_client
import logging, traceback

logging.basicConfig(level=logging.DEBUG)
log = logging.getLogger('report.main')

def run(job_id=None, project=None, scenario=None, code_path="./report_utilities/reports/", clear_data=None):

    #Open the numerous client
    with open_client(job_id=job_id, project=project, scenario=scenario, clear_data=clear_data) as client:
        try:
            client.set_scenario_progress('Initializing', 'initializing', 0, force=True)
            import papermill as pm
            import os

            job = client.get_job()
            params = job['image']['parameters']

            notebook = None
            report_template = 'report_template_em'
            prefix = ""
            for p in params:
                if p['id'] == 'report_notebook':
                    notebook = p['value']
                elif p['id'] == 'report_template':
                    report_template = p['value']
                elif p['id'] == 'prefix':
                    prefix = p['value']

            if notebook is None:
                raise ValueError('No notebook defined!')

            os.chdir(code_path)

            client.set_scenario_progress('Launched', 'running', 0, force=True)


            pm.execute_notebook(
                f'./{notebook}.ipynb',
                f'./{notebook}_out.ipynb',
                parameters=dict(auto_generated=True, report_template=f'{report_template}.html',
                                prefix =prefix, instance_id=client._instance_id
                                )
            )

            client.set_scenario_progress('Completed', 'finished', 0, force=True)

        except KeyboardInterrupt:
            client.set_scenario_progress('Terminated', 'terminated', 0, force=True)

        except Exception:
            tb = traceback.format_exc()
            log.error(tb)

            client.set_scenario_progress('Failed', 'failed', 0, force=True)


if __name__ == '__main__':
    run()