from grpc_interceptor import ClientCallDetails, ClientInterceptor
from typing import Callable, Any
import grpc
import uuid

class ValidationInterceptor(ClientInterceptor):
    def __init__(self, token, instance):
        self.token = token
        self.instance = str(uuid.uuid4()) if instance is None else instance

    def intercept(self, method: Callable, request_or_iterator: Any, call_details: grpc.ClientCallDetails):
        new_details = ClientCallDetails(
            call_details.method,
            call_details.timeout,
            [("token", str(self.token)), ("instance", str(self.instance))],
            call_details.credentials,
            call_details.wait_for_ready,
            call_details.compression,
        )

        return method(request_or_iterator, new_details)
