class Numerous:
    def __init__(self):
        self.termination_callbacks = []

    def terminate_callback(self, f):
        self.termination_callbacks.append(f)
        return f

    def terminate(self):
        for tc in self.termination_callbacks:
            tc()


app = Numerous()

stop = {'STOP': False}

@app.terminate_callback
def terminate():
    stop['STOP'] = True

if __name__ == '__main__':
    app.terminate()



