import threading

from datetime import datetime, timedelta
from time import sleep


class NumerousLogHandler:
    def __init__(self, client, admin_log_id=None, echo=False):
        self.client = client
        self.buffered_records = []
        self.last_push = datetime.utcnow() - timedelta(hours=1)
        self.debounce = 5
        self.admin_log_id = admin_log_id
        self.echo = echo

        def timed_flush():
            while True:
                sleep(1)
                now_ = datetime.utcnow()
                if (now_ - self.last_push).seconds > self.debounce:
                    self.last_push = now_
                    self.flush()

        threading.Thread(target=timed_flush, daemon=True).start()

    def handle(self, record):
        self.log(record.msg)

    def log(self, message):
        now_ = datetime.utcnow()
        record = (now_, message)
        self.buffered_records.append(record)
        if self.echo:
            print(record)

        if (now_ - self.last_push).seconds > self.debounce:
            self.last_push = now_
            self.flush()

    def flush(self):
        if len(self.buffered_records) > 0:
            to_push = self.buffered_records.copy()
            self.buffered_records = []
            if self.admin_log_id is not None:
                self.client.push_scenario_logs_admin(to_push, exe_id=self.admin_log_id)
            else:
                self.client.push_scenario_logs(to_push)

    def close(self):
        self.flush()

    # TODO make a handler thread to schedule update to server!
