import logging
import os
import threading

from enum import Enum
from time import time

log = logging.getLogger('numerous_client')
log.setLevel(logging.DEBUG)


class Interp(Enum):
    zero = 0
    linear = 1
    quadratic = 2


class JobStatus(Enum):
    ready = 0
    running = 1
    finished = 2
    request_termination = 3
    terminated = 4
    failed = 5
    requested = 6
    initializing = 7


def get_env(val, env, default=None):
    if val is None:
        env_val = os.getenv(env)

        if env_val is None:
            if default is None:
                raise KeyError(f'ENV var <{env}> is not set.')
            else:
                return default

        return env_val
    else:
        return val


class RepeatedFunction:
    def __init__(self, interval, function, run_initially=False, *args, **kwargs):
        self._timer = None
        self.interval = interval
        self.function = function
        self.args = args
        self.kwargs = kwargs
        self.is_running = False
        self.next_call = time()

        if run_initially:
            self.function(*self.args, **self.kwargs)

    def _run(self):
        self.is_running = False
        self.start()
        self.function(*self.args, **self.kwargs)

    def start(self):
        if not self.is_running:
            self.next_call += self.interval
            self._timer = threading.Timer(self.next_call - time(), self._run)
            self._timer.start()
            self.is_running = True

    def stop(self):
        self._timer.cancel()
        self.is_running = False
