import os
from http.server import BaseHTTPRequestHandler, HTTPServer
from threading import Thread


class HealthCheckRequestHandler(BaseHTTPRequestHandler):

    def do_GET(self):
        if self.path == "/health_check":
            self.send_response(200, 'OK')
        else:
            self.send_response(400, 'Only Health Checks Allowed')
        self.end_headers()
    
    def log_request(self, *args, **kwargs) -> None:
        """Override to silence logging."""
        pass


def _run_health_check_server():
    port = int(os.getenv("NUMEROUS_API_HEALTH_CHECK_PORT"))
    httpd = HTTPServer(('0.0.0.0', port), HealthCheckRequestHandler)
    httpd.serve_forever()


def serve_health_check_endpoint():
    thread = Thread(target=_run_health_check_server)
    thread.start()
    return thread