from enum import Enum
import logging
log = logging.getLogger('numerous_api.tokens.validation')

class AccessLevel(int, Enum):
    ANY = 0
    READ = 1
    WRITE = 2
    DEVELOPER = 3
    OWNER = 4
    ADMIN = 5

class ValidationException(Exception):
    pass

class ValidationObjectType(int, Enum):
    SCENARIO = 0
    GROUP = 1
    PROJECT = 2

def validate_access_token(
                        access_token,
                         token_project_id,
                         token_scenario_id,
                         token_admin,
                         token_access_level,
                         required_access_level,
                         requested_project_id,
                         requested_scenario_id,
                         validation_object_type=None
                         ):

    # Admin rights - allow any action
    if token_admin:
        log.debug(f"Validated access token for required level {required_access_level.name} due to admin claim")
        return True

    ## If not admin, and admin is required, disallow
    #if required_access_level == AccessLevel.ADMIN.value:
    #    log.debug(f"Rejected access token for required level {required_access_level.name} due to missing admin claim")
    #    return False

    # Validate access level
    if token_access_level < required_access_level.value:
        log.debug(
            f"Rejected access token for required level {required_access_level.name} due to insufficient claim {access_token or '<claim missing>'}")
        return False

    if token_access_level >= AccessLevel.DEVELOPER.value:
        log.debug(f"Validated ")
        return True

    # Check that a validation object type is given
    if validation_object_type is None:
        raise ValidationException("No validation object given!")

    # Scenarios
    if validation_object_type == ValidationObjectType.SCENARIO.value and requested_scenario_id == token_scenario_id:
        log.debug(
            f"Validated access token for required level {required_access_level.name} due to scenario claim {token_scenario_id}")
        return True

    # Group - access given through project
    elif validation_object_type == ValidationObjectType.GROUP.value and requested_project_id == token_project_id:
        log.debug(
            f"Validated access token for required level {required_access_level.name} due to scenario claim {token_project_id}")
        return True

    # Projects
    elif validation_object_type == ValidationObjectType.PROJECT.value and requested_project_id == token_project_id:
        log.debug(
            f"Validated access token for required level {required_access_level.name} due to scenario claim {token_project_id}")
        return True

    log.debug(f"Rejected access token for required level {required_access_level.name} due to unmatched claims.")
    return False