import datetime
import logging
import traceback

import grpc

import numerous_api_client.python_protos.spm_pb2 as spm_pb2
from . import firebase as fire


is_debug = True


def json_serial(obj):
    """JSON serializer for objects not serializable by default json code"""

    if isinstance(obj, (datetime.datetime, datetime.date)):
        return obj.timestamp()
    raise TypeError ("Type %s not serializable" % type(obj))


class ErrorHandler:

    def set_error(self, exception_cls, code: grpc.StatusCode=grpc.StatusCode.INTERNAL, msg :str='Internal Error Occured!'):
        self.code = code
        self.msg = msg
        raise exception_cls(self.msg)

class NumerousBaseException(Exception):
    grpc_error_code = grpc.StatusCode.INTERNAL

def standard_error_handling():
    def wrapper(f):
        def print_traceback(self, request, context):
            try:
                res = f(self, request, context)

                return res
            except Exception as e:
                traceback.print_exc()

                if isinstance(e, NumerousBaseException):
                    #In case the exception is of type NumerousBaseException - forward text to the client
                    self.code = e.grpc_error_code
                    self.msg = str(e)

                    context.set_code(self.code)
                    context.set_details(_debug(self.msg, request))

                elif not hasattr(self, 'code') or self.code is None:
                    self.code = grpc.StatusCode.INTERNAL
                    self.msg = 'Internal error occurred in endpoint. Please check server logs.'

                    context.set_code(self.code)
                    context.set_details(_debug(self.msg,request))

                    raise

                else:
                    context.set_code(self.code)
                    context.set_details(_debug(self.msg, request))

                self.code = None
                self.msg = None
                return spm_pb2.Empty()
        return print_traceback
    return wrapper


def _debug(_str, request):
    debug_str = []
    if is_debug:
        if hasattr(request, 'project_id'):
            if not fire.check_project_exist(request.project_id):
                logging.warning(f"PROJECT PROBLEM! {request.project_id}")
                debug_str.append(f'Project {request.project_id} does not exist!')
            else:
                if not fire.check_scenario_exist(request.project_id, request.scenario_id):
                    debug_str.append(f'Scenario {request.scenario_id} does not exist!')
                else:
                    if hasattr(request, 'job_id'):
                        if not fire.check_job_exist(request.project_id, request.scenario_id, request.job_id):
                            debug_str.append(f'Job {request.job_id} does not exist!')

    if len(debug_str)>0:
        debug_str= [_str, 'hints:']+debug_str

        return "\n".join(debug_str)
    else:
        return _str