import yaml, os
import logging

log = logging.getLogger('numerous_env')
log.setLevel(logging.DEBUG)

config_folder = '../../deployment/app/k8s/overlays/local/'

yaml_env_list = [
    ('secret_token.yaml', [('secret_phrase', 'NUMEROUS_TOKEN_SECRET')]),
    ('storage_configuration.yaml', [('bucket', 'NUMEROUS_BUCKET')]),
    ('secret_firebase_service_account.yaml', [('service_account', 'NUMEROUS_FIREBASE_SERVICE_ACCOUNT')]),
    ('secret_storage_service_account.yaml', [('service_account', 'NUMEROUS_STORAGE_SERVICE_ACCOUNT')]),

    #('secret_bigtable_service_account.yaml', [('service_account', 'NUMEROUS_BIGTABLE_SERVICE_ACCOUNT')]),
    ('bigtable_configuration.yaml', [
        ('url', 'NUMEROUS_BIGTABLE_SERVER_URL'),
        ('server_certificate', 'NUMEROUS_BIGTABLE_SERVER_CERT'),

        ('bigtable_prefix', 'NUMEROUS_BIGTABLE_API_PREFIX')
                                                           ]),
('secret_bigtable_refresh_token.yaml', [
    ('secret_phrase', 'NUMEROUS_BIGTABLE_API_REFRESH_TOKEN')]),
    ('grpc_server_configuration.yaml', [
        ('api_address', 'NUMEROUS_API_SERVER'),
        ('api_port', 'NUMEROUS_API_PORT'),
        ('insecure_api_address', 'NUMEROUS_SERVICE_ADDRESS'),
        ('insecure_api_port', 'NUMEROUS_SERVICE_PORT'),
        ('redis_host', 'REDIS_HOST'),
        ('redis_port', 'REDIS_PORT'),
                                                           ]),
    ('deployment_config.yaml', [('deployment_config', 'NUMEROUS_DEPLOYMENT_CONFIGURATIONS')]),



]

def load_env_from_yaml():
    log.debug(f'Loading env variables from local yaml files in {config_folder}')
    for env_def in yaml_env_list:

        with open(config_folder+env_def[0], 'r') as f:
            secret_yaml = yaml.load(f, Loader=yaml.FullLoader)
            for env_var in env_def[1]:
                log.debug('Setting env: ' + env_var[1])
                os.environ[env_var[1]] = secret_yaml['stringData'][env_var[0]]