from numerous_api_client.python_protos import spm_pb2, spm_pb2_grpc
from api.tests.utils.GRPCTestBase import GRPCTestBase
from api.numerous_api.server import SPMServicer
from unittest import TestCase

import json


class SPMStub(GRPCTestBase, TestCase):
    """Handles setup of stub for accessing the SPM servicer."""
    def setUp(self) -> None:
        super(SPMStub, self).setUp()

        self.default_firestore_project = "FXRtXbIfKOCm4D232rjX"
        self.default_firestore_group = "TmIhRIq8xFUFphoFMR7P"
        self.default_firestore_scenario = "LGHTmmxnY1inTiDTRYxF"

        spm_pb2_grpc.add_SPMServicer_to_server(SPMServicer(), self._server)
        self.stub = spm_pb2_grpc.SPMStub(self._channel)


class SPMBasicTests(SPMStub, TestCase):
    def test_get_project(self):
        """Assert that getting a project returns a non-empty dictionary with the correct project ID."""
        response = self.stub.GetProject(request=spm_pb2.Project(project=self.default_firestore_project))

        assert (response.project == self.default_firestore_project)
        assert (isinstance(response.project_document, str) and len(json.loads(response.project_document)) != 0)

    def test_get_group(self):
        """Assert that getting a group returns a non-empty dictionary with the correct group ID."""
        response = self.stub.GetGroup(request=spm_pb2.Group(
            group=self.default_firestore_group, project=self.default_firestore_project
        ))

        assert (response.group == self.default_firestore_group)
        assert (isinstance(response.group_document, str) and len(json.loads(response.group_document)) != 0)

    def test_get_scenario(self):
        """Assert that getting a scenario returns a non-empty dictionary with the correct scenario ID."""
        response = self.stub.GetScenario(request=spm_pb2.Scenario(
            scenario=self.default_firestore_scenario, project=self.default_firestore_project)
        )

        assert (response.scenario == self.default_firestore_scenario)
        assert (isinstance(response.scenario_document, str) and len(json.loads(response.scenario_document)) != 0)
