from ..numerous_api.services.token_validation import validation

access_token = 'sadfdsdfsdfsfd'
project = "project1"
project2 = "project2"
scenario = "scenario1"
scenario2 = "scenario2"
#Test if admin
def test_admin():

    #Test of access admin in token will pass hardest case
    assert validation.validate_access_token(
        access_token = access_token,
        token_project_id = project,
        token_scenario_id = scenario,
        token_admin = True,
        token_access_level = validation.AccessLevel.ADMIN,
        required_access_level = validation.AccessLevel.ADMIN,
        requested_project_id = project2,
        requested_scenario_id = scenario2,
        validation_object_type=validation.ValidationObjectType.SCENARIO
    ) == True, "Access token with admin = True should always pass validation"

def test_admin_level():
    assert validation.validate_access_token(
        access_token=access_token,
        token_project_id=project,
        token_scenario_id=scenario,
        token_admin=False,
        token_access_level=validation.AccessLevel.ADMIN,
        required_access_level=validation.AccessLevel.ADMIN,
        requested_project_id=project2,
        requested_scenario_id=scenario2,
        validation_object_type=validation.ValidationObjectType.SCENARIO
    ) == True, "Validation should be rejected for non token_admin when Accesslevel is admin in Token"

def test_token_below_required_access_level():

    for level in validation.AccessLevel:
        assert validation.validate_access_token(
            access_token=access_token,
            token_project_id=project,
            token_scenario_id=scenario,
            token_admin=False,
            token_access_level=level-1,
            required_access_level=level,
            requested_project_id=project2,
            requested_scenario_id=scenario2,
            validation_object_type=validation.ValidationObjectType.SCENARIO
        ) == False, "Validation should be rejected for non token_admin when Accesslevel is below admin in Token"

def test_token_equal_required_access_level():

    for level in validation.AccessLevel:
        assert validation.validate_access_token(
            access_token=access_token,
            token_project_id=project,
            token_scenario_id=scenario,
            token_admin=False,
            token_access_level=level,
            required_access_level=level,
            requested_project_id=project,
            requested_scenario_id=scenario,
            validation_object_type=validation.ValidationObjectType.SCENARIO
        ) == True, "Validation should be rejected for non token_admin when Accesslevel is below admin in Token"

def test_token_validation_scenario():

    for level in validation.AccessLevel:
        pass_val = level >= validation.AccessLevel.DEVELOPER
        assert validation.validate_access_token(
            access_token=access_token,
            token_project_id=project,
            token_scenario_id=scenario,
            token_admin=False,
            token_access_level=level,
            required_access_level=level,
            requested_project_id=project,
            requested_scenario_id=scenario2,
            validation_object_type=validation.ValidationObjectType.SCENARIO
        ) == pass_val, f"token/required access level {level} with {validation.ValidationObjectType.SCENARIO} should validate: {pass_val}"

def test_token_validation_project():

    for level in validation.AccessLevel:
        pass_val = level >= validation.AccessLevel.ANY
        assert validation.validate_access_token(
            access_token=access_token,
            token_project_id=project,
            token_scenario_id=scenario,
            token_admin=False,
            token_access_level=level,
            required_access_level=level,
            requested_project_id=project,
            requested_scenario_id=scenario2,
            validation_object_type=validation.ValidationObjectType.PROJECT
        ) == pass_val, f"token/required access level {level} with {validation.ValidationObjectType.SCENARIO} should validate: {pass_val}"

def test_token_validation_project_different_project():

    for level in validation.AccessLevel:
        pass_val = level >= validation.AccessLevel.DEVELOPER
        assert validation.validate_access_token(
            access_token=access_token,
            token_project_id=project,
            token_scenario_id=scenario,
            token_admin=False,
            token_access_level=level,
            required_access_level=level,
            requested_project_id=project2,
            requested_scenario_id=scenario2,
            validation_object_type=validation.ValidationObjectType.PROJECT
        ) == pass_val, f"token/required access level {level} with {validation.ValidationObjectType.SCENARIO} should validate: {pass_val}"