import os
import json
import traceback
import sys

os.environ['NUMEROUS_BIGTABLE_DATA_TABLE']="spm_scenario_data_test"
os.environ['NUMEROUS_BIGTABLE_INSTANCE']="simsimulation"
os.environ['NUMEROUS_BIGTABLE_LOG_TABLE']="execution_logs"
os.environ['PREFIX']="numerous-development"

def set_service_account():
    service_account_file = '../../../simtool-208411-21387edcbff2.json'
    with open(service_account_file, 'r') as f:
        service_account = json.load(f)

    os.environ['NUMEROUS_BIGTABLE_SERVICE_ACCOUNT'] = json.dumps(service_account)



def tb_str(e):
    s=traceback.format_exception(etype=type(e), value=e, tb=e.__traceback__)
    return [ss.strip() for ss in s]

class BigtableDebug:
    def __init__(self, execution, scenario):

        prefix= os.getenv('PREFIX')
        self.prefix = prefix

        pwd = os.getcwd()
        prev="\\".join(pwd.split("\\")[:-1])

        sys.path.insert(0, prev+"\\src")

        from data_processor import DataProcessor
        from data_drivers import BigTableDriver

        bt = DataProcessor(BigTableDriver())

        if os.getenv('NUMEROUS_BIGTABLE_SERVICE_ACCOUNT') is None:
            set_service_account()

        key=bt._form_row_key(scenario,execution).decode('UTF-8')
        self.key = key

        self.bt = bt
    def read_data_stats(self):
        return self.bt.read_data_stats(self.prefix, self.key)
    def get_meta_data(self):
        return json.loads(self.bt.get_meta_data(self.prefix, self.key, "meta"))

    def read_time_range(self, tags, start, end):
        return self.bt.read_time_range(self.prefix, self.key, tags, start, end)






