from numerous_api_client.client import open_client
import os
from bigtable_debug import BigtableDebug, tb_str

def test_query():
    inputscenario = "U2C9t8NXLvn1gW3myfhx"
    execution = "4dbc64a7_7bff_45b9_a3e5_3335e10b0544"

    os.environ['NUMEROUS_SCENARIO']="27UFgqui46hCcI2xP1pQ"
    os.environ['NUMEROUS_PROJECT']="2H75ixrhSX5qamRy1uzs"
    os.environ['JOB_ID'] = "9c758c70_2cd9_4b72_a5db_e6a2d745dad7"


    #offset = 1609455600
    with open_client() as client:
        meta=client.get_timeseries_meta_data(scenario=inputscenario, execution=execution)
        #execution = meta.execution
        offset = meta.offset

        bt = BigtableDebug(execution, inputscenario)

        stats = bt.read_data_stats()
        intervals = stats.get('t_block_interval')

        for interval in intervals:
            t0 = offset+interval[0]
            te = offset+interval[1]
            ti = (t0+te)/2
            scenario = client.get_scenario()[0]
            input=client.get_inputs(t0=t0, te=te, scenario_data=scenario, tag_prefix='', tag_seperator='.', timeout=120)
            try:
                inputs=input.get_at_time(ti)
                print(f"requested time: {ti} - actual time {inputs['_index']}")
                assert((ti-inputs['_index']) == 0), f"values are not matching {ti-inputs['_index']}!=0"
            except Exception as e:
                print(f"some error occured:  {tb_str(e)}")
                continue

def test_data_in_range():
    execution = "6c653149_f7c8_4868_9844_054c8e9307d7"
    scenario = "U2C9t8NXLvn1gW3myfhx"

    bt = BigtableDebug(execution, scenario)

    stats = bt.read_data_stats()
    intervals = stats.get('t_block_interval')

    tags = ['outside_air_inlet_temperature', '_index']

    ok = 0
    for ix, interval in enumerate(intervals):
        start = interval[0]
        end = min(interval[1] + 60, intervals[-1][-1])

        data = bt.read_time_range(tags, start, end)
        times = []
        for d in data:
            times += d[0][0]['values']

        if (start >= min(times) and start <= max(times)) and (end >= min(times) and end <= max(times)):
            print(f'SUCCESS: start {start} and end {end} in range {min(times)}-{max(times)}')
            ok += 1
        else:
            print(f'FAILED: start {start} and end {end} not in range {min(times)}-{max(times)}')

    assert (ok == len(intervals)), f"not all values ({ok}) are in range"

if __name__ == "__main__":
    test_data_in_range()
    test_query()