from microservices.numerous_bigtable_grpc.tests.bigtable_debug import BigtableDebug, set_service_account
from microservices.numerous_bigtable_grpc.src import numerous_bigtable_pb2
import sys
import logging

set_service_account()

execution = "ebd2109b-02b3-4218-ba8a-fcd93dfd7a86"
scenario = "BJya1k3K6zTS2oOp2ixY"
prefix = 'numerous-development'
tags = {'Stub.VS.P', 'Stub.VV.P', 'Stub.Ambient.air.T', 'Stub.VV.T_set', 'Stub.VV.P_VVC', 'Stub.KB.P'}
tmax = 31532400.0

log = logging.getLogger('bigtable_test_read_data')
log.setLevel(logging.DEBUG)
streamhandler = logging.StreamHandler(sys.stdout)
formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
streamhandler.setFormatter(formatter)
log.addHandler(streamhandler)

class Request:
    def __init__(self, prefix=None, key=None, tags=None, start=None, end=None, time_range=True, **kwargs):
        self.prefix = prefix
        self.key = key
        self.tags = tags
        self.start = start
        self.end = end
        self.time_range = time_range

debug = BigtableDebug(execution=execution, scenario=scenario)
bigtable = debug.bt



def read_data_server(request: Request):
    if request.time_range:
        data = bigtable.read_time_range(request.prefix, request.key, request.tags, request.start, request.end)
    else:
        data = bigtable.read_block_range(request.prefix, request.key, request.tags, request.start, request.end)

    for d in data:

        data_blocks = []
        blocks_size = 0

        for i, _d in enumerate(d[0]):
            new_block = numerous_bigtable_pb2.DataBlock(**_d)

            new_block_size = sys.getsizeof(new_block)

            # log.debug('block size: '+str(new_block_size))
            # log.debug('tot block size: ' + str(blocks_size))

            if blocks_size + new_block_size > 4e6 / 70:
                row_complete = d[1] if i + 1 == len(d[0]) else False
                block_complete = d[2] if i + 1 == len(d[0]) else False
                yield numerous_bigtable_pb2.DataList(prefix=request.prefix, key=request.key, data=data_blocks,
                                                     row_complete=row_complete, block_complete=block_complete)

                data_blocks = []
                blocks_size = 0

            blocks_size += new_block_size
            data_blocks.append(new_block)

        if len(data_blocks) > 0:
            yield numerous_bigtable_pb2.DataList(prefix=request.prefix, key=request.key, data=data_blocks,
                                                 row_complete=d[1], block_complete=d[2])
    log.debug(f'Reading data completed')

generator=read_data_server(Request(prefix=prefix, key=debug.key, tags=tags, start=0, end=tmax+1))
i=0
for g in generator:
    i+=1
assert i==52, f"generator didn't return entire range: {i}"

