from .firestore_files import firestore_classes as fire
import json
import os


class _ImporterBase:
    def __init__(self, read_path='./outputs', service_account='writer.json', use_emulator=False):
        print(service_account)
        self._writer = fire.FirestoreWriter(service_account=service_account, use_emulator=use_emulator)
        self._read_path = read_path
        self._json = {}

    def load_json_from_file(self, file_name: str = 'out.json') -> None:
        """Load JSON from file."""
        with open(f"{self._read_path}/{file_name}", 'r') as f:
            _loaded_json = json.loads(f.read())
            for col, cont in _loaded_json.items():
                print(col)
                self._json[col] = [
                    fire.FirestoreDocument(
                        path=doc['path'], collections=doc['collections'], data=doc['data'], type_=doc['type_']
                    ) for doc in cont['data']
                ]

    def get_json(self) -> str:
        """Return current exported JSON."""
        return json.dumps(self._json, default=fire.FirestoreObject.to_json)

    def import_json(self) -> None:
        """Import loaded JSON into specified firestore project."""
        for col, cont in self._json.items():
            for doc in cont:
                print("IMPORTING: ", doc.path)
                self._writer.write_document(doc)


class Importer:
    def __init__(self, read_path='./outputs', use_emulator: bool = False, service_account=None):
        self._importer = _ImporterBase(use_emulator=use_emulator, read_path=read_path, service_account=service_account)

    def import_from_json(self):
        print("-------------------------------------------------------------")
        print("|                 IMPORTING FROM JSON FILE                  |")
        print("-------------------------------------------------------------")
        self._importer.import_json()

    def load_from_file_to_import(self, file_name: str) -> None:
        """Load data into importer from file."""
        self._importer.load_json_from_file(file_name=file_name)

    def load_json_from_folder(self, path: str or None = None) -> None:
        _path = path if path is not None else self._importer._read_path
        for root, dirs, files in os.walk(_path):
            for file in files:
                self.load_from_file_to_import(file_name=file)

    def read_imported_json(self) -> str:
        """Read the data that is currently stored in the importer."""
        return self._importer.get_json()
