import yaml, os
import logging

log = logging.getLogger('numerous_env')
log.setLevel(logging.DEBUG)

config_folder = '../../../deployment/bigtable-microservice/k8s/overlays/terraform/'

yaml_env_list = [
    ('secret_token.yaml', [('secret_phrase', 'NUMEROUS_TOKEN_SECRET')]),
    ('secret_bigtable_service_account.yaml', [('service_account', 'NUMEROUS_BIGTABLE_SERVICE_ACCOUNT')]),
    ('bigtable_configuration.yaml', [
        ('instance_name', 'NUMEROUS_BIGTABLE_INSTANCE'),
        ('data_table_name', 'NUMEROUS_BIGTABLE_DATA_TABLE'),
        ('log_table_name', 'NUMEROUS_BIGTABLE_LOG_TABLE'),
('server_certificate', 'NUMEROUS_BIGTABLE_SERVER_CERT'),
                                                           ]),


    ('grpc_server_configuration.yaml', [
        ('api_address', 'NUMEROUS_API_SERVER'),
        ('api_port', 'NUMEROUS_API_PORT'),

                                                           ]),
]

def load_env_from_yaml():
    log.debug(f'Loading env variables from local yaml files in {config_folder}')
    for env_def in yaml_env_list:

        with open(config_folder+env_def[0], 'r') as f:
            secret_yaml = yaml.load(f, Loader=yaml.FullLoader)
            for env_var in env_def[1]:
                log.debug('Setting env: ' + env_var[1])
                os.environ[env_var[1]] = secret_yaml['stringData'][env_var[0]]