import yaml


class YamlGenerator:
    def __init__(self, template_path='./microservices/numerous_deployment_grpc/src/yaml_templates/templates/'):  # '/api_services/yaml_templates/templates/'):
        self.template_path = template_path

    @staticmethod
    def format_param_name(key):
        return f'${{ {key} }}'

    @staticmethod
    def format_param_value(val):
        return str(val).lower().replace(" ", "-").replace("_", "-")

    def search_and_replace(self, search_obj, _keys, _values):
        if isinstance(search_obj, dict):
            for k, v in search_obj.items():
                if v in _keys:
                    search_obj[k] = _values[_keys.index(v)]

                if isinstance(v, dict) or isinstance(v, list):
                    self.search_and_replace(v, _keys, _values)

        if isinstance(search_obj, list):
            for k in search_obj:
                if k in _keys:
                    search_obj[search_obj.index(k)] = _keys[_keys.index(_values)]

                if isinstance(k, dict) or isinstance(k, list):
                    self.search_and_replace(k, _keys, _values)

    def generate_env(self, env_variables: dict) -> list:
        return [{'name': k, 'value': str(v)} for k, v in env_variables.items()]

    def load_template(self, template_name):
        file_path = self.template_path + template_name + '.yaml'
        with open(file_path) as file:
            return yaml.load(file, Loader=yaml.Loader)

    def generate_yaml(self, params, template_name, env_variables: dict = None):
        template = self.load_template(template_name)
        formatted_names = [self.format_param_name(param) for param in params.keys()]
        formatted_values = [self.format_param_value(v) for v in params.values()]

        self.search_and_replace(template, formatted_names, formatted_values)

        # This is somewhat of a hack and does not generalize... Should be updated. Maybe add ability to add a env path?
        if env_variables is not None:
            template['spec']['template']['spec']['containers'][0]['env'] += self.generate_env(env_variables)

        return template