from http.server import HTTPServer, BaseHTTPRequestHandler
import ssl
import json
import os
import threading
from time import sleep



def serve(keyfile, certfile, server, port):
    with open(certfile, 'r') as f:
        cert_str = f.read()

    class H(BaseHTTPRequestHandler):


        def do_GET(s):

            if s.path == '/cert':
                s.send_response(200)
                s.send_header("Content-type", "data/json")

                s.end_headers()



                json_ = json.dumps({"cert": cert_str})
                s.wfile.write(f"{json_}".encode('UTF-8'))
            else:
                s.send_response(404)
                s.send_header("Content-type", "data/json")

                s.end_headers()

                json_ = json.dumps({})
                s.wfile.write(f"{json_}".encode('UTF-8'))

    httpd = HTTPServer((server, port), H)
    print(keyfile)
    print(certfile)
    httpd.socket = ssl.wrap_socket (httpd.socket,
            keyfile=keyfile,
            certfile=certfile, server_side=True)

    print('starting certificate server')
    httpd.serve_forever()

def serve_env(keyenv, certenv, server, port):
    key = os.getenv(keyenv)
    cert = os.getenv(certenv)

    keypath = './key.pem'
    with open(keypath, 'w') as keyfile:
        keyfile.write(key)

    certpath = './cert.pem'
    with open(certpath, 'w') as certfile:
        certfile.write(cert)

    server_thread = threading.Thread(target=serve, args=(keypath, certpath, server, port), daemon=True)
    server_thread.start()




if __name__ == '__main__':
    keyfile = "./secret.key"
    certfile = './secret_certificate.crt'

    with open(keyfile, 'r') as kf:
        os.environ['NUMEROUS_SERVER_KEY'] = kf.read()

    with open(certfile, 'r') as cf:
        os.environ['NUMEROUS_SERVER_CERT'] = cf.read()

    server = '0.0.0.0'

    serve_env('NUMEROUS_SERVER_KEY', 'NUMEROUS_SERVER_CERT', server, 4443)

    sleep(100)